import { Request, Response } from 'express';
import { aiService } from './service';

function hasFeature(vendor: any, featureKey: string): boolean {
  // Assume vendor.features is an array of enabled feature keys
  return vendor?.features?.includes(featureKey);
}

export const aiController = {
  async generateReminder(req: any, res: Response) {
    const vendor = req.vendor;
    if (!hasFeature(vendor, 'ai_assistant')) {
      return res.status(403).json({ error: 'AI Assistant not available on your plan.' });
    }
    const { name, occasion, style } = req.body;
    const result = await aiService.generateReminder(vendor.id, { name, occasion, style });
    return res.json(result);
  },

  async generateGreeting(req: any, res: Response) {
    const vendor = req.vendor;
    if (!hasFeature(vendor, 'ai_assistant')) {
      return res.status(403).json({ error: 'AI Assistant not available on your plan.' });
    }
    const { name, context, style } = req.body;
    const result = await aiService.generateGreeting(vendor.id, { name, context, style });
    return res.json(result);
  },

  async generateShoppingAssist(req: any, res: Response) {
    const vendor = req.vendor;
    if (!hasFeature(vendor, 'ai_assistant')) {
      return res.status(403).json({ error: 'AI Assistant not available on your plan.' });
    }
    const { items, context } = req.body;
    const result = await aiService.generateShoppingAssist(vendor.id, { items, context });
    return res.json(result);
  },

  async generatePriceInsight(req: any, res: Response) {
    const vendor = req.vendor;
    if (!hasFeature(vendor, 'ai_assistant')) {
      return res.status(403).json({ error: 'AI Assistant not available on your plan.' });
    }
    const { item, market, trend } = req.body;
    const result = await aiService.generatePriceInsight(vendor.id, { item, market, trend });
    return res.json(result);
  },

  async general(req: any, res: Response) {
    const vendor = req.vendor;
    if (!hasFeature(vendor, 'ai_assistant')) {
      return res.status(403).json({ error: 'AI Assistant not available on your plan.' });
    }
    const { prompt, context } = req.body;
    const result = await aiService.generalAssistant(vendor.id, { prompt, context });
    return res.json(result);
  }
}; 